import {expect} from 'chai';
import decache from 'decache';
let express = require('express');

import {expressWs} from '../src/index';

function resetExpress() {
  decache('express');
  express = require('express');
}

describe('expressWs()', function() {
  it('should add a .ws() method to the given express app', function() {
    const app = express();
    const eWs = expressWs(app);
    expect(app.ws).to.be.a('function');
  });

  it('should add a .ws() method to Routers in the given app', function() {
    const app = express();
    const eWs = expressWs(app);
    const router = new express.Router();
    expect(router.ws).to.be.a('function');
    resetExpress();
  });

  it('should not add a .ws() method to Routers if the "leaveRouterUntouched" option is set', function() {
    const app = express();
    const wsOptions = {
      leaveRouterUntouched: true
    };
    const eWs = expressWs(app, null, wsOptions);
    const router = new express.Router();
    expect(router.ws).to.be.undefined;
  });
});
